/*******************************************************************
*
*  DESCRIPTION: Atomic Model Registrar
*
*  AUTHOR: Srivastav janapalli
*
*  EMAIL: sjana086@uottawa.ca
*
*  DATE: 30/10/2016
*
*******************************************************************/

#include "registrar.h"
#include "message.h"
#include "mainsimu.h"
#include <time.h>    // time()


/** public functions **/

/*************************************************************************
* Function Name: Registrar
* Description:	define in, out ports and the process time of verifications
**************************************************************************/
Registrar::Registrar( const string &name )
: Atomic( name )
, applicationVerificationIN( addInputPort( "applicationVerificationIN" ) )
, applicationVerificationOUT( addOutputPort( "applicationVerificationOUT" ) )
, minStandardsNotMet( addOutputPort( "minStandardsNotMet" ) )
, registrarTime( 0, 0, 9, 0 )
{

}

/*******************************************************************
* Function Name: initFunction
* Description: define the initial state
* Precondition: the model should be in the passive mode
********************************************************************/
Model &Registrar::initFunction()
{
	this-> passivate();

	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &Registrar::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == applicationVerificationIN && this->state() == passive)
	{
		studentGrade = static_cast < int >( msg.value() );
		checkNum = studentGrade & 30 ;
		if( checkNum > 25 )
		{
			lowGrade = true;
			holdIn ( active, registrarTime );
		}
		else{

			lowGrade = false;
			holdIn( active, registrarTime );

		}
	}
	//cout << "registrarTime: " << registrarTime;
	//cout << "studentGrade: " << studentGrade;

	return *this;
}


/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &Registrar::internalFunction( const InternalMessage & )
{

	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &Registrar::outputFunction( const InternalMessage &msg )
{	if ( lowGrade )
	{	
		sendOutput( msg.time(), minStandardsNotMet, studentGrade ) ;
	}
	else
		sendOutput ( msg.time(), applicationVerificationOUT, studentGrade );
	return *this ;

}
